
import gurobipy as gp

# Create a new model
model = gp.Model("Mixture_Optimization")

# Define the variables
x1 = model.addVar(name="Mixture_1", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Mixture_2", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(10*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 15*x2 <= 1000, name="Almonds_Constraint")
model.addConstr(30*x1 + 20*x2 <= 1200, name="Pecans_Constraint")
model.addConstr(10*x1 + 25*x2 <= 1100, name="Pistachios_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Mixture 1 = {x1.varValue}, Mixture 2 = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
