
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
wheat = m.addVar(lb=0, name="wheat")
corn = m.addVar(lb=0, name="corn")

# Set objective function
m.setObjective(50 * wheat + 90 * corn, GRB.MAXIMIZE)

# Add constraints
m.addConstr(wheat + corn <= 90, "land")
m.addConstr(10 * wheat + 20 * corn <= 1400, "maintenance")
m.addConstr(4 * wheat + 3 * corn <= 90, "care")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Wheat: {wheat.x}")
    print(f"Acres of Corn: {corn.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

