
from gurobipy import *

# Create a new model
m = Model("Samuel_Farm")

# Create variables
x1 = m.addVar(name='x1', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='x2', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(50*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 90, name='land_constraint')
m.addConstr(10*x1 + 20*x2 <= 1400, name='maintenance_cost_constraint')
m.addConstr(4*x1 + 3*x2 <= 90, name='care_time_constraint')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f'Optimal solution: x1 = {x1.x}, x2 = {x2.x}')
    print(f'Total profit: {50*x1.x + 90*x2.x}')
else:
    print('No optimal solution found')
