
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="acres_of_wheat")
    x2 = model.addVar(lb=0, name="acres_of_corn")

    # Objective function: Maximize 50*x1 + 90*x2
    model.setObjective(50*x1 + 90*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 + 20*x2 <= 1400, name="maintenance_cost")
    model.addConstr(4*x1 + 3*x2 <= 90, name="care_hours")
    model.addConstr(x1 + x2 <= 90, name="total_acres")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of wheat: {x1.varValue}")
        print(f"Acres of corn: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
