
from gurobipy import *

# Create a model
m = Model("Ferry_Ticket_Sales")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_rate_tickets")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="concession_rate_tickets")

# Set the objective function
m.setObjective(2*x1 + 0.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "total_capacity")
m.addConstr(x2 >= 15, "concession_min")
m.addConstr(x1 >= 5*x2, "regular_rate_proportion")
m.addConstr(x1 >= 0, "non_negative_regular")
m.addConstr(x2 >= 0, "non_negative_concession")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular rate tickets: {x1.x}")
    print(f"Concession rate tickets: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
