
import gurobi

def solve_ferry_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="regular_rate_tickets", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="concession_rate_tickets", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize 2*x1 + 0.5*x2
    model.setObjective(2*x1 + 0.5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 120, name="total_capacity")
    model.addConstr(x2 >= 15, name="concession_rate_min")
    model.addConstr(x1 >= 5*x2, name="regular_to_concession_rate")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Regular rate tickets: {x1.varValue}")
        print(f"Concession rate tickets: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_ferry_ticket_problem()
