
from gurobipy import Model, GRB

# Create a new model
m = Model("movie_theatre")

# Create variables
zg = m.addVar(lb=0, vtype=GRB.INTEGER, name="zero_gravity")  # Zero gravity seats
st = m.addVar(lb=0, vtype=GRB.INTEGER, name="standard")  # Standard seats

# Set objective function
m.setObjective(55 * zg + 25 * st, GRB.MAXIMIZE)

# Add constraints
m.addConstr(zg + st <= 250, "capacity")  # Theatre capacity
m.addConstr(zg >= 40, "min_zg")  # Minimum zero gravity seats
m.addConstr(st >= 4 * zg, "preference")  # Preference for standard seats

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Zero gravity seats: {zg.x}")
    print(f"Standard seats: {st.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

