
from gurobipy import *

# Create a new model
m = Model("Movie_Theatre_Seating")

# Define variables
x1 = m.addVar(lb=0, name="zero_gravity_seats")
x2 = m.addVar(lb=0, name="standard_seats")

# Set the objective function
m.setObjective(55*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 250, "total_seats_limit")
m.addConstr(x1 >= 40, "zero_gravity_minimum")
m.addConstr(x2 >= 4*x1, "standard_vs_zero_gravity_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of zero gravity seats: {x1.x}")
    print(f"Optimal number of standard seats: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
