
import gurobi

def solve_movie_theatre_seating():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="zero_gravity_seats", lb=0, vtype=gurobi.GRB.INTEGER)  # Zero gravity seats
    x2 = model.addVar(name="standard_seats", lb=0, vtype=gurobi.GRB.INTEGER)  # Standard seats

    # Objective function: Maximize profit
    model.setObjective(55 * x1 + 25 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 250, name="total_seats")  # Total seats constraint
    model.addConstr(x1 >= 40, name="min_zero_gravity")  # Minimum zero gravity seats
    model.addConstr(x2 >= 4 * x1, name="std_vs_zero_gravity")  # Standard vs zero gravity preference

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of zero gravity seats: {x1.varValue}")
        print(f"Number of standard seats: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_movie_theatre_seating()
