
import gurobipy as gp

# Create a new model
model = gp.Model("TeddyBearProduction")

# Create variables
small_bears = model.addVar(vtype=gp.GRB.INTEGER, name="small_bears")
large_bears = model.addVar(vtype=gp.GRB.INTEGER, name="large_bears")

# Set objective function
model.setObjective(50 * small_bears + 8 * large_bears, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * small_bears + 10 * large_bears <= 700, "filling_constraint")
model.addConstr(25 * small_bears + 35 * large_bears <= 900, "stitching_constraint")
model.addConstr(small_bears >= 0, "small_bears_nonnegative")
model.addConstr(large_bears >= 0, "large_bears_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small teddy bears: {small_bears.x}")
    print(f"Number of large teddy bears: {large_bears.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

