
from gurobipy import *

# Create a new model
m = Model("Teddy_Bear_Profit")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_teddy_bears")
x2 = m.addVar(vtype=GRB.INTEGER, name="large_teddy_bears")

# Set the objective function
m.setObjective(50*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 10*x2 <= 700, "filling_time")
m.addConstr(25*x1 + 35*x2 <= 900, "stitching_time")
m.addConstr(x1 >= 0, "non_neg_small")
m.addConstr(x2 >= 0, "non_neg_large")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
