
import gurobi

def solve_teddy_bear_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="small_teddy_bear")
    x2 = model.addVar(vtype=gurobi.GRB.INTEGER, name="large_teddy_bear")

    # Objective function: maximize 50*x1 + 8*x2
    model.setObjective(50*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 10*x2 <= 700, name="filling_time_constraint")
    model.addConstr(25*x1 + 35*x2 <= 900, name="stitching_time_constraint")
    model.addConstr(x1 >= 0, name="non_negativity_constraint_x1")
    model.addConstr(x2 >= 0, name="non_negativity_constraint_x2")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of small teddy bears: {x1.varValue}")
        print(f"Number of large teddy bears: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_teddy_bear_problem()
