
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("coffee_pods")

# Create variables
small_pods = m.addVar(vtype=GRB.INTEGER, name="small_pods")
large_pods = m.addVar(vtype=GRB.INTEGER, name="large_pods")

# Set objective function
m.setObjective(3 * small_pods + 5 * large_pods, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * small_pods + 20 * large_pods <= 2000, "coffee_constraint")
m.addConstr(small_pods >= 4 * large_pods, "ratio_constraint")
m.addConstr(large_pods >= 10, "min_large_pods")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of small pods: {small_pods.x}")
    print(f"Number of large pods: {large_pods.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

