
from gurobipy import *

# Create a new model
m = Model("Coffee_Pod_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_coffee_pods")
x2 = m.addVar(vtype=GRB.INTEGER, name="large_coffee_pods")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 20*x2 <= 2000, "coffee_availability")
m.addConstr(x1 >= 4*x2, "small_vs_large_ratio")
m.addConstr(x2 >= 10, "minimum_large_pods")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small coffee pods: {x1.x}")
    print(f"Large coffee pods: {x2.x}")
    print(f"Maximum profit: ${3*x1.x + 5*x2.x:.2f}")
else:
    print("No optimal solution found")
