
import gurobi

def solve_coffee_pod_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="small_coffee_pods", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="large_coffee_pods", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x1 + 20 * x2 <= 2000, name="coffee_limit")
    model.addConstr(x1 >= 4 * x2, name="small_to_large_ratio")
    model.addConstr(x2 >= 10, name="min_large_pods")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: small coffee pods = {x1.varValue}, large coffee pods = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_coffee_pod_problem()
