
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("dessert_optimization")

# Create variables
cupcakes = m.addVar(vtype=GRB.CONTINUOUS, name="cupcakes")  # x1
cakes = m.addVar(vtype=GRB.CONTINUOUS, name="cakes")  # x2


# Set objective function
m.setObjective(10 * cupcakes + 25 * cakes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * cupcakes + 60 * cakes <= 9000, "oven_time")
m.addConstr(60 * cupcakes + 120 * cakes <= 12000, "cooling_time")
m.addConstr(cupcakes >=0)
m.addConstr(cakes >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Batches of cupcakes: {cupcakes.x:.2f}")
    print(f"Batches of cakes: {cakes.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

