
from gurobipy import *

# Create a model
m = Model("Dessert_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cupcakes", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cakes", lb=0)

# Set the objective function
m.setObjective(10*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 60*x2 <= 9000, "oven_time")
m.addConstr(60*x1 + 120*x2 <= 12000, "cooling_rack_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of batches of cupcakes: {x1.x}")
    print(f"Number of batches of cakes: {x2.x}")
    print(f"Maximum profit: ${10*x1.x + 25*x2.x:.2f}")
else:
    print("No optimal solution found.")
