
import gurobipy as gp

# Create a new model
model = gp.Model("Dessert_Optimization")

# Define the variables
x1 = model.addVar(name="cupcakes", lb=0)  # batches of cupcakes
x2 = model.addVar(name="cakes", lb=0)     # batches of cakes

# Define the objective function
model.setObjective(10*x1 + 25*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(20*x1 + 60*x2 <= 9000, name="oven_constraint")
model.addConstr(60*x1 + 120*x2 <= 12000, name="cooling_rack_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Batches of Cupcakes: {x1.varValue}")
    print(f"Batches of Cakes: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
