
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("soil_mix")

# Create variables
indoor_soil = m.addVar(lb=0, name="indoor_soil")  # x1
outdoor_soil = m.addVar(lb=0, name="outdoor_soil") # x2

# Set objective function
m.setObjective(2 * indoor_soil + 3 * outdoor_soil, GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * indoor_soil + 4 * outdoor_soil >= 80, "compost_req")
m.addConstr(3 * indoor_soil + 6 * outdoor_soil >= 70, "loam_req")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal}")
    print(f"Indoor soil: {indoor_soil.x}")
    print(f"Outdoor soil: {outdoor_soil.x}")

