
from gurobipy import *

# Create a new model
m = Model("Soil_Mix")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="indoor_soil", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="outdoor_soil", lb=0)

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 80, "compost_requirement")
m.addConstr(3*x1 + 6*x2 >= 70, "loam_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount of indoor soil: {x1.x}")
    print(f"Amount of outdoor soil: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
