
import gurobi

def solve_soil_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='indoor_soil', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='outdoor_soil', lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 4*x2 >= 80, name='compost_requirement')
    model.addConstr(3*x1 + 6*x2 >= 70, name='loam_requirement')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of indoor soil: {x1.varValue}")
        print(f"Optimal amount of outdoor soil: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_soil_mix_problem()
