
import gurobipy as gp

# Create a new model
model = gp.Model("Theta_Sandwich_Advertising")

# Create variables
newspaper_ads = model.addVar(vtype=gp.GRB.INTEGER, name="newspaper_ads")
radio_ads = model.addVar(vtype=gp.GRB.INTEGER, name="radio_ads")
tv_ads = model.addVar(vtype=gp.GRB.INTEGER, name="tv_ads")

# Set objective function
model.setObjective(5000 * newspaper_ads + 1000 * radio_ads + 8000 * tv_ads, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1200 * newspaper_ads + 500 * radio_ads + 2000 * tv_ads <= 100000, "budget_constraint")
model.addConstr(radio_ads <= 10, "radio_limit")
model.addConstr(tv_ads <= (newspaper_ads + radio_ads + tv_ads) / 3, "tv_proportion")
model.addConstr(newspaper_ads >= 0.2 * (newspaper_ads + radio_ads + tv_ads), "newspaper_proportion")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Viewers: {model.objVal}")
    print(f"Newspaper Ads: {newspaper_ads.x}")
    print(f"Radio Ads: {radio_ads.x}")
    print(f"Television Ads: {tv_ads.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

