
from gurobipy import *

# Create a new model
m = Model("Theta_Sandwich_Advertisement")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="newspaper_ads")
x2 = m.addVar(vtype=GRB.INTEGER, name="radio_ads")
x3 = m.addVar(vtype=GRB.INTEGER, name="television_ads")

# Set objective function
m.setObjective(5000*x1 + 1000*x2 + 8000*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1200*x1 + 500*x2 + 2000*x3 <= 100000, "budget_constraint")
m.addConstr(x2 <= 10, "radio_ads_limit")
m.addConstr(x3 <= (1/3)*(x1 + x2 + x3), "television_ads_limit")
m.addConstr(x1 >= 0.20*(x1 + x2 + x3), "newspaper_ads_minimum")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Newspaper Ads: {x1.x}")
    print(f"Radio Ads: {x2.x}")
    print(f"Television Ads: {x3.x}")
else:
    print("No optimal solution found")
