
import gurobipy as gp

# Create a new model
m = gp.Model("Theta_Sandwich_Ads")

# Define the variables
x1 = m.addVar(name="newspaper_ads", lb=0, vtype=gp.GRB.INTEGER)  # Number of newspaper ads
x2 = m.addVar(name="radio_ads", lb=0, vtype=gp.GRB.INTEGER)    # Number of radio ads
x3 = m.addVar(name="television_ads", lb=0, vtype=gp.GRB.INTEGER)  # Number of television ads

# Objective function: Maximize the total number of viewers
m.setObjective(5000*x1 + 1000*x2 + 8000*x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(1200*x1 + 500*x2 + 2000*x3 <= 100000, name="budget_constraint")  # Budget constraint
m.addConstr(x2 <= 10, name="radio_ads_constraint")  # Radio ads constraint
m.addConstr(2*x3 <= x1 + x2, name="television_ads_constraint")  # Television ads constraint
m.addConstr(4*x1 >= x2 + x3, name="newspaper_ads_constraint")  # Newspaper ads constraint

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of newspaper ads: {x1.varValue}")
    print(f"Number of radio ads: {x2.varValue}")
    print(f"Number of television ads: {x3.varValue}")
    print(f"Total viewers: {5000*x1.varValue + 1000*x2.varValue + 8000*x3.varValue}")
else:
    print("No optimal solution found.")
