
import gurobipy as gp

# Create a new model
m = gp.Model("Cow Feed Optimization")

# Create variables
silage = m.addVar(lb=0, name="silage")  # Kilograms of silage
grains = m.addVar(lb=0, name="grains")  # Kilograms of mixed grains


# Set objective function: Minimize cost
m.setObjective(215 * silage + 320 * grains, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.5 * silage + 0.2 * grains >= 2 * 50, "Protein")  # Protein constraint
m.addConstr(0.1 * silage + 0.2 * grains >= 1.5 * 50, "Minerals")  # Minerals constraint
m.addConstr(0.2 * silage + 0.1 * grains <= 1 * 50, "Vitamins")  # Vitamins constraint


# Optimize the model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Kilograms of silage: {silage.x:.2f}")
    print(f"Kilograms of mixed grains: {grains.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

