
from gurobipy import *

# Create a new model
m = Model("cow_feeding")

# Define variables
x1 = m.addVar(name="silage", lb=0)
x2 = m.addVar(name="mixed_grains", lb=0)

# Set objective function
m.setObjective(50*(215*x1 + 320*x2), GRB.MINIMIZE)

# Add constraints
m.addConstr(0.5*x1 + 0.2*x2 >= 2, name="protein_requirement")
m.addConstr(0.1*x1 + 0.2*x2 >= 1.5, name="minerals_requirement")
m.addConstr(0.2*x1 + 0.1*x2 <= 1, name="vitamins_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Silage per cow per day: {x1.x}")
    print(f"Mixed grains per cow per day: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
