
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="silage_per_cow", lb=0)
    x2 = model.addVar(name="grains_per_cow", lb=0)

    # Objective function: minimize cost
    model.setObjective(215 * x1 + 320 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.5 * x1 + 0.2 * x2 >= 2, name="protein_requirement")
    model.addConstr(0.1 * x1 + 0.2 * x2 >= 1.5, name="minerals_requirement")
    model.addConstr(0.2 * x1 + 0.1 * x2 <= 1.0, name="vitamins_limit")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Silage per cow: {x1.varValue}")
        print(f"Mixed grains per cow: {x2.varValue}")
        print(f"Total cost per cow: {215 * x1.varValue + 320 * x2.varValue}")
        print(f"Total cost for 50 cows: {(215 * x1.varValue + 320 * x2.varValue) * 50}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
