
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_problem")

# Create variables
logging = m.addVar(name="logging")
shipping = m.addVar(name="shipping")

# Set objective function
m.setObjective(0.06 * logging + 0.03 * shipping, GRB.MAXIMIZE)

# Add constraints
m.addConstr(logging + shipping <= 3000, "total_investment")
m.addConstr(logging >= 0.5 * (logging + shipping), "logging_percentage")
m.addConstr(shipping >= 1000, "min_shipping")
m.addConstr(logging >=0, "logging_nonnegative") # Explicit non-negativity constraints
m.addConstr(shipping >=0, "shipping_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${logging.x:.2f} in logging")
    print(f"Invest ${shipping.x:.2f} in shipping")
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

