
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="logging_investment")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="shipping_investment")

# Set the objective function
m.setObjective(0.06*x1 + 0.03*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 0.5*(x1 + x2), "logging_minimum")
m.addConstr(x2 >= 1000, "shipping_minimum")
m.addConstr(x1 + x2 <= 3000, "total_investment")
m.addConstr(x1 >= 0, "non_negative_logging")
m.addConstr(x2 >= 0, "non_negative_shipping")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Logging Investment: {x1.x}")
    print(f"Shipping Investment: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
