
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="logging_investment", lb=0)
    x2 = model.addVar(name="shipping_investment", lb=0)

    # Objective function: Maximize 0.06*x1 + 0.03*x2
    model.setObjective(0.06 * x1 + 0.03 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 3000, name="total_investment")
    model.addConstr(x1 >= x2, name="logging_min_percentage")
    model.addConstr(x2 >= 1000, name="shipping_min_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in logging industry: $", x1.varValue)
        print("Optimal investment in shipping industry: $", x2.varValue)
        print("Maximum profit: $", 0.06 * x1.varValue + 0.03 * x2.varValue)
    else:
        print("The problem is infeasible")

solve_investment_problem()
