
import gurobipy as gp

# Create a new model
model = gp.Model("Sausage_and_Burger_Production")

# Create variables
sausages = model.addVar(vtype=gp.GRB.CONTINUOUS, name="sausages")  # batches of sausages
burgers = model.addVar(vtype=gp.GRB.CONTINUOUS, name="burgers")  # batches of burger patties


# Set objective function
model.setObjective(200 * sausages + 250 * burgers, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * sausages + 4 * burgers <= 3000, "meat_grinder_constraint")
model.addConstr(3 * sausages + 1.5 * burgers <= 3000, "meat_packer_constraint")
model.addConstr(sausages >= 0, "sausages_nonnegative")
model.addConstr(burgers >= 0, "burgers_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of sausage batches: {sausages.x}")
    print(f"Number of burger patty batches: {burgers.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

