
from gurobipy import *

# Create a new model
model = Model("Sausage_and_Burger_Patties")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="sausages", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="burger_patties", lb=0)

# Set the objective function
model.setObjective(200*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x1 + 4*x2 <= 3000, "meat_grinder")
model.addConstr(3*x1 + 1.5*x2 <= 3000, "meat_packer")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of batches of sausages: {x1.x}")
    print(f"Number of batches of burger patties: {x2.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
