
import gurobipy as gp

# Create a new model
model = gp.Model("Sausages_and_Burger_Patties")

# Define the variables
x1 = model.addVar(name="x1", lb=0, vtype=gp.GRB.CONTINUOUS)  # batches of sausages
x2 = model.addVar(name="x2", lb=0, vtype=gp.GRB.CONTINUOUS)  # batches of burger patties

# Define the objective function
model.setObjective(200 * x1 + 250 * x2, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(2 * x1 + 4 * x2 <= 3000, name="meat_grinder_constraint")
model.addConstr(3 * x1 + 1.5 * x2 <= 3000, name="meat_packer_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of sausages: {x1.varValue}")
    print(f"Optimal batches of burger patties: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
