
import gurobipy as gp

# Create a new model
m = gp.Model("brunch_optimization")

# Create variables
eggs_benedict = m.addVar(vtype=gp.GRB.CONTINUOUS, name="eggs_benedict")
hashbrown = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hashbrown")

# Set objective function
m.setObjective(4 * eggs_benedict + 2 * hashbrown, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * eggs_benedict + 5 * hashbrown <= 5000, "butter_constraint")
m.addConstr(1 * eggs_benedict + 2 * hashbrown <= 600, "egg_constraint")
m.addConstr(eggs_benedict >= 0, "eggs_benedict_nonnegativity")
m.addConstr(hashbrown >= 0, "hashbrown_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Eggs Benedict: {eggs_benedict.x}")
    print(f"Number of Hashbrowns: {hashbrown.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

