
from gurobipy import *

# Create a new model
m = Model("Brunch_Optimization")

# Add variables
x1 = m.addVar(name="eggs_benedicts", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="hashbrowns", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(4*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 <= 5000, name="butter_constraint")
m.addConstr(x1 + 2*x2 <= 600, name="eggs_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
    print(f"Maximum profit: ${int(m.objVal)}")
else:
    print("No optimal solution found")

