
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="eggs_benedicts", lb=0, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="hashbrowns", lb=0, ub=gurobi.GRB.INFINITY)

# Set the objective function
m.setObjective(4 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x1 + 5 * x2 <= 5000, name="butter_constraint")
m.addConstr(x1 + 2 * x2 <= 600, name="egg_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Eggs benedicts: {x1.varValue}")
    print(f"Hashbrowns: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
