
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("popcorn_mix")

# Create variables
sweet_mix = m.addVar(name="sweet_mix")  # x1: pounds of sweet mix
regular_mix = m.addVar(name="regular_mix") # x2: pounds of regular mix

# Set objective function: Maximize profit
m.setObjective(3 * sweet_mix + 2 * regular_mix, GRB.MAXIMIZE)

# Add constraints:
# Butter popcorn constraint: 0.25 * sweet_mix + 0.5 * regular_mix <= 30
m.addConstr(0.25 * sweet_mix + 0.5 * regular_mix <= 30, "butter_popcorn")

# Caramel popcorn constraint: 0.75 * sweet_mix + 0.5 * regular_mix <= 40
m.addConstr(0.75 * sweet_mix + 0.5 * regular_mix <= 40, "caramel_popcorn")


# Non-negativity constraints are added by default in gurobipy when using addVar


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Pounds of sweet mix: {sweet_mix.x:.2f}")
    print(f"Pounds of regular mix: {regular_mix.x:.2f}")

