
from gurobipy import *

# Create a new model
m = Model("popcorn_optimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sweet_mix")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="regular_mix")

# Set the objective function
m.setObjective(3*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.25*x1 + 0.5*x2 <= 30, "butter_popcorn_constraint")
m.addConstr(0.75*x1 + 0.5*x2 <= 40, "caramel_popcorn_constraint")
m.addConstr(x1 >= 0, "non_negativity_sweet_mix")
m.addConstr(x2 >= 0, "non_negativity_regular_mix")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sweet mix: {x1.x} pounds")
    print(f"Regular mix: {x2.x} pounds")
    print(f"Maximum profit: ${3*x1.x + 2*x2.x}")
else:
    print("No optimal solution found.")
