
import gurobipy as gp

# Create a new model
m = gp.Model("popcorn_mix")

# Define variables
x1 = m.addVar(name="sweet_mix", lb=0)  # bags of sweet mix
x2 = m.addVar(name="regular_mix", lb=0)  # bags of regular mix

# Objective function: maximize profit
m.setObjective(3*x1 + 2*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.75*x1 + 0.5*x2 <= 40, name="caramel_constraint")
m.addConstr(0.25*x1 + 0.5*x2 <= 30, name="butter_constraint")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Bags of sweet mix: {x1.varValue}")
    print(f"Bags of regular mix: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found")
