
import gurobipy as gp

# Create a new model
model = gp.Model("Boarstone_Factory")

# Create variables
regular_machines = model.addVar(vtype=gp.GRB.INTEGER, name="regular_machines")
advanced_machines = model.addVar(vtype=gp.GRB.INTEGER, name="advanced_machines")


# Set objective function
model.setObjective(1000 * regular_machines + 10000 * advanced_machines, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * regular_machines + 25 * advanced_machines >= 120, "tasks_per_hour")
model.addConstr(2 * regular_machines + 5 * advanced_machines <= 20, "max_workers")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Number of regular machines: {regular_machines.x}")
    print(f"Number of advanced machines: {advanced_machines.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

