
from gurobipy import *

# Create a new model
m = Model("Boarstone_Factory")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="regular_machines")
x2 = m.addVar(vtype=GRB.INTEGER, name="advanced_machines")

# Set the objective function: minimize cost
m.setObjective(1000*x1 + 10000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 25*x2 >= 120, "task_requirement")
m.addConstr(2*x1 + 5*x2 <= 20, "worker_limit")
m.addConstr(x1 >= 0, "non_neg_regular")
m.addConstr(x2 >= 0, "non_neg_advanced")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of regular machines: {x1.x}")
    print(f"Number of advanced machines: {x2.x}")
    print(f"Total cost: ${1000*x1.x + 10000*x2.x}")
else:
    print("No optimal solution found.")
