
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="regular_machines", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="advanced_machines", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 1000*x1 + 10000*x2
    model.setObjective(1000*x1 + 10000*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x1 + 25*x2 >= 120, name="tasks_per_hour")
    model.addConstr(2*x1 + 5*x2 <= 20, name="workers")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
