
import gurobipy as gp

# Create a new model
m = gp.Model("clothing_optimization")

# Create variables
red_shirts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="red_shirts")
green_shirts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="green_shirts")

# Set objective function
m.setObjective(20 * red_shirts + 35 * green_shirts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * red_shirts + 5 * green_shirts <= 1500, "dye_constraint")
m.addConstr(5 * red_shirts + 8 * green_shirts <= 3000, "water_constraint")
m.addConstr(20 * red_shirts + 25 * green_shirts <= 8000, "worker_minutes_constraint")
m.addConstr(red_shirts >= 0, "red_shirts_nonnegative")
m.addConstr(green_shirts >= 0, "green_shirts_nonnegative")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Red Shirts: {red_shirts.x}")
    print(f"Green Shirts: {green_shirts.x}")
    print(f"Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

