
from gurobipy import *

# Create a new model
m = Model("Fancy_Clothing-Co")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="red_shirts", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="green_shirts", lb=0)

# Set the objective function
m.setObjective(20*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 5*x2 <= 1500, "dye_constraint")
m.addConstr(5*x1 + 8*x2 <= 3000, "water_constraint")
m.addConstr(20*x1 + 25*x2 <= 8000, "worker_minutes_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red shirts: {x1.x}")
    print(f"Green shirts: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
