
import gurobipy as gp

# Create a new model
model = gp.Model("FancyClothingCo")

# Define variables
x1 = model.addVar(name="red_shirts", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="green_shirts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(20*x1 + 35*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 5*x2 <= 1500, name="dye_constraint")
model.addConstr(5*x1 + 8*x2 <= 3000, name="water_constraint")
model.addConstr(20*x1 + 25*x2 <= 8000, name="worker_minutes_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
  print(f"Optimal solution: red shirts = {x1.varValue}, green shirts = {x2.varValue}")
  print(f"Maximal profit: ${model.objVal:.2f}")
else:
  print("No optimal solution found.")
