
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Miniature_Animals")

# Create variables
bears = m.addVar(vtype=GRB.INTEGER, name="bears")  # Number of mini bears
dogs = m.addVar(vtype=GRB.INTEGER, name="dogs")  # Number of mini dogs


# Set objective function
m.setObjective(40 * bears + 47 * dogs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * bears + 7 * dogs <= 400, "Cotton_Constraint")
m.addConstr(bears + dogs <= 40, "Total_Animals_Constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of mini bears: {bears.x}")
    print(f"Number of mini dogs: {dogs.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

