
from gurobipy import *

# Create a new model
m = Model("artist_problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mini_bears")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mini_dogs")

# Set the objective function
m.setObjective(40*x1 + 47*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 7*x2 <= 400, "cotton_constraint")
m.addConstr(x1 + x2 <= 40, "total_animals_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mini bears: {x1.x}")
    print(f"Mini dogs: {x2.x}")
    print(f"Maximum profit: ${40*x1.x + 47*x2.x}")
else:
    print("No optimal solution found")
