
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="mini_bears", lb=0, ub=None, obj=40)
    x2 = model.addVar(name="mini_dogs", lb=0, ub=None, obj=47)

    # Add constraints
    model.addConstr(x1 + x2 <= 40, name="time_constraint")
    model.addConstr(8*x1 + 7*x2 <= 400, name="cotton_constraint")

    # Set the model objective
    model.setObjective(x1.obj * x1.varName + x2.obj * x2.varName, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Mini bears: {x1.x}")
        print(f"Mini dogs: {x2.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
