
import gurobipy as gp

# Create a new model
m = gp.Model("Nut_Combo_Optimization")

# Create decision variables
x1 = m.addVar(lb=0, name="Combo_X")  # Kilograms of Combo X
x2 = m.addVar(lb=0, name="Combo_Y")  # Kilograms of Combo Y

# Set objective function: Maximize profit
m.setObjective(35 * x1 + 55 * x2, gp.GRB.MAXIMIZE)

# Add constraints:
# Almond constraint
m.addConstr(0.7 * x1 + 0.35 * x2 <= 35, "Almond_Constraint")

# Hazelnut constraint
m.addConstr(0.3 * x1 + 0.65 * x2 <= 20, "Hazelnut_Constraint")


# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Kilograms of Combo X: {x1.x}")
    print(f"Kilograms of Combo Y: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

