
from gurobipy import *

# Create a model
m = Model("Nut_Combo_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Combo_X")
x2 = m.addVar(lb=0, name="Combo_Y")

# Set the objective function
m.setObjective(35*x1 + 55*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x1 + 0.35*x2 <= 35, "Almond_Limit")
m.addConstr(0.3*x1 + 0.65*x2 <= 20, "Hazelnut_Limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Combo X: {x1.x} kg")
    print(f"Combo Y: {x2.x} kg")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
